
{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 50000,0,655360}


unit algs ;


interface


uses

  Graph, vars ;


const

  algs_nr = 4 ;

  algs_names : array [1..algs_nr] of String =
    ('Last Flr','Next Flr','Down-Up','Empty') ;


procedure algorytms ;
procedure reset_algs ;

implementation


{-----------------------------------------------------------------------}
{ ALGORYTMS IMPLEMENTATION                                              }
{-----------------------------------------------------------------------}


procedure alg_down_up ;

var
  i, j : Integer ;
  b : Boolean ;
begin
  for i:=1 to n do begin
    if (elv_vec[i]=1)and(elv_pos[i]<m) then begin
      j:=elv_pos[i]+1 ;
      while (j<=m)and(floors_up[j]=0) do Inc(j) ;
      if j<=m then elv_to[i]:= j ;
    end ;
    if (elv_vec[i]=-1)and(elv_pos[i]>1) then begin
      j:=elv_pos[i]-1 ;
      while (j>=1)and(floors_down[j]=0) do Dec(j) ;
      if j>=1 then elv_to[i]:= j ;
    end ;

    b:=False ;
    if elv_vec[i]=0 then begin
      if elv_pos[i]>1 then begin
        j:=elv_pos[i]-1 ;
        while (j>=1)and(floors_down[j]=0) do Dec(j) ;
        if j>=1 then begin
          elv_to[i]:=j ;
          elv_vec[i]:=-1 ;
          b:=True ;
        end else begin
          j:=1 ;
          while (j<elv_pos[i])and(floors_up[j]=0) do Inc(j) ;
          if j<elv_pos[i] then begin
            elv_to[i]:=j ;
            elv_vec[i]:=-1 ;
            b:=True ;
          end ;
        end ;
      end ;
      if (not b)and(elv_pos[i]<m) then begin
        j:=elv_pos[i]+1 ;
        while (j<=m)and(floors_up[j]=0) do Inc(j) ;
        if j<=m then begin
          elv_to[i]:=j ;
          elv_vec[i]:=1 ;
        end else begin
          j:=m ;
          while (j>elv_pos[i])and(floors_down[j]=0) do Dec(j) ;
          if j>elv_pos[i] then begin
            elv_to[i]:=j ;
            elv_vec[i]:=1 ;
          end ;
        end ;
      end ;
    end ;
  end ;
end ;



{-----------------------------------------------------------------------}


var

  elv_vec2 : arr20int ;


procedure alg_easy ;
var
  i : Integer ;
begin
  for i:=1 to n do begin
    if elv_vec[i]=0 then begin
      if elv_vec2[i]=-1 then begin
        if elv_pos[i]>1 then begin
          elv_to[i]:=1 ;
          elv_vec[i]:=-1 ;
        end else begin
          elv_to[i]:=m ;
          elv_vec[i]:=1 ;
          elv_vec2[i]:=1 ;
        end ;
      end ;
      if elv_vec2[i]=1 then begin
        if elv_pos[i]<m then begin
          elv_to[i]:=m ;
          elv_vec[i]:=1 ;
        end else begin
          elv_to[i]:=1 ;
          elv_vec[i]:=-1 ;
          elv_vec2[i]:=-1 ;
        end ;
      end ;
    end ;
  end ;
end ;


{-----------------------------------------------------------------------}


var
  down_tab : array [1..20] of Byte ;
  up_tab   : array [1..20] of Byte ;
  fl       : array [1..20] of Byte ;


{-----------------------------------------------------------------------}


procedure alg_NextFlr ;

var
  l, i, j : Integer ;
  b, pb : Byte ;

begin

  for l:=1 to m do begin

    i:=fl[l] ;

    if elv_pos[down_tab[i]]=i then down_tab[i]:=0 ;
    if elv_pos[up_tab[i]]=i then up_tab[i]:=0 ;

    if (floors_up[i]>0) then begin

      pb:=255 ;
      for j:=1 to n do begin
        if ((elv_vec[j]=0)or((elv_pos[j]<i)and(elv_vec[j]=1)))
         and((elv_to[j]>=i)or(elv_to[j]=0))and(Abs(i-elv_pos[j])<pb) then begin
          b:=j ;
          pb:=Abs(i-elv_pos[j]) ;
        end ;
      end ;

      if pb<>255 then begin
        if (up_tab[i]=0)or((up_tab[i]<>0)and(pb<Abs(i-elv_pos[up_tab[i]]))) then begin
          elv_to[up_tab[i]]:=elv_pos[b]+elv_vec[b] ;
          elv_to[b]:=i ;
          if i>elv_pos[b] then elv_vec[b]:=1 ;
          if i<elv_pos[b] then elv_vec[b]:=-1 ;
          up_tab[i]:=b ;
        end ;
      end ;

    end ;

    if (floors_down[i]>0) then begin

      pb:=255 ;
      for j:=1 to n do begin
        if ((elv_vec[j]=0)or((elv_pos[j]>i)and(elv_vec[j]=-1)))
         and((elv_to[j]<=i)or(elv_to[j]=0))and(Abs(i-elv_pos[j])<pb) then begin
          b:=j ;
          pb:=Abs(i-elv_pos[j]) ;
        end ;
      end ;

      if (pb<>255) then begin
        if (down_tab[i]=0)or((down_tab[i]<>0)and(pb<Abs(i-elv_pos[down_tab[i]]))) then begin
          elv_to[down_tab[i]]:=elv_pos[b]+elv_vec[b] ;
          elv_to[b]:=i ;
          if i>elv_pos[b] then elv_vec[b]:=1 ;
          if i<elv_pos[b] then elv_vec[b]:=-1 ;
          down_tab[i]:=b ;
        end ;
      end ;

    end ;

  end ;

end ;


{-----------------------------------------------------------------------}


procedure alg_LastFlr ;

var
  l, i, j : Integer ;
  b, pb : Byte ;

begin

  for l:=1 to m do begin

    i:=fl[l] ;

    if elv_pos[down_tab[i]]=i then down_tab[i]:=0 ;
    if elv_pos[up_tab[i]]=i then up_tab[i]:=0 ;

    if (floors_up[i]>0) then begin

      pb:=255 ;
      for j:=1 to n do begin
        if (elv_pos[j]<i)and((elv_vec[j]=1)or(elv_vec[j]=0))
         and((elv_to[j]>=i)or(elv_to[j]=0))and(Abs(i-elv_pos[j])<pb) then begin
          b:=j ;
          pb:=Abs(i-elv_pos[j]) ;
        end ;
      end ;

      if pb<>255 then begin
        if (up_tab[i]=0)or((up_tab[i]<>0)and(pb<Abs(i-elv_pos[up_tab[i]]))) then begin
          elv_to[up_tab[i]]:=elv_pos[b]+elv_vec[b] ;
          elv_to[b]:=i ;
          if i>elv_pos[b] then elv_vec[b]:=1 ;
          if i<elv_pos[b] then elv_vec[b]:=-1 ;
          up_tab[i]:=b ;
        end ;
      end ;

    end ;

    if (floors_down[i]>0) then begin

      pb:=255 ;
      for j:=1 to n do begin
        if (elv_pos[j]>i)and((elv_vec[j]=-1)or(elv_vec[j]=0))
         and((elv_to[j]<=i)or(elv_to[j]=0))and(Abs(i-elv_pos[j])<pb) then begin
          b:=j ;
          pb:=Abs(i-elv_pos[j]) ;
        end ;
      end ;

      if (pb<>255) then begin
        if (down_tab[i]=0)or((down_tab[i]<>0)and(pb<Abs(i-elv_pos[down_tab[i]]))) then begin
          elv_to[down_tab[i]]:=elv_pos[b]+elv_vec[b] ;
          elv_to[b]:=i ;
          if i>elv_pos[b] then elv_vec[b]:=1 ;
          if i<elv_pos[b] then elv_vec[b]:=-1 ;
          down_tab[i]:=b ;
        end ;
      end ;

    end ;

  end ;

  for j:=1 to n do begin
    if elv_vec[j]=0 then begin
      i:=m ;
      while (i>elv_pos[j])and((floors_down[i]=0)or(down_tab[i]<>0)) do Dec(i) ;
      l:=1 ;
      while (l<elv_pos[j])and((floors_up[l]=0)or(up_tab[l]<>0)) do Inc(l) ;

      if (i>elv_pos[j])and((l=elv_pos[j])or(i-elv_pos[j]<=elv_pos[j]-l)) then begin
        elv_vec[j]:=1 ;
        elv_to[j]:=i ;
        down_tab[i]:=j ;
      end ;

      if (l<elv_pos[j])and((i=elv_pos[j])or(i-elv_pos[j]>elv_pos[j]-l)) then begin
        elv_vec[j]:=-1 ;
        elv_to[j]:=l ;
        up_tab[l]:=j ;
      end ;
    end ;
  end ;
end ;


{-----------------------------------------------------------------------}


procedure alg_empty ;
begin
end ;


{-----------------------------------------------------------------------}
{ End of ALGORYTMS IMPLEMENTATION                                       }
{-----------------------------------------------------------------------}


procedure algorytms ;

begin

  case nr_alg of

{--------ALGORYTMS NUMBERS---------}

    1 : alg_lastflr ;
    2 : alg_nextflr ;
    3 : alg_down_up ;
    4 : alg_empty ;

{-----End of ALGORYTMS NUMBERS-----}

  end ;

end ;


{-----------------------------------------------------------------------}
{ STARTUP                                                               }
{-----------------------------------------------------------------------}



procedure reset_algs ;
var
  i, j : Integer ;
  b : Byte ;
begin

  for i:=1 to 20 do begin
    elv_vec2[i]:=1 ;
    down_tab[i]:=0 ;
    up_tab[i]:=0 ;
    fl[i]:=i ;
  end ;

  for i:=1 to m do
    for j:=1 to m-1 do
      if attr_lv[fl[j]]<attr_lv[fl[j+1]] then begin
        b:=fl[j] ;
        fl[j]:=fl[j+1] ;
        fl[j+1]:=b ;
      end ;

end ;



begin end.