/*
 *	Bellman-Ford Algorithm v1.0
 *	Copyright (C) 2007 by Karol Kozłowski
 *	
 */

#include <spa.h>
#include <stack>
#include <graph.h>
#include <bellman_ford.h>

bellman_ford::bellman_ford(graph* g){
	solved = 0;
	graphptr = g;
	
	D = new int[graphptr->numVertex];
	P = new int[graphptr->numVertex];

}

bellman_ford::~bellman_ford(){
	delete [] D;	D = NULL;
	delete [] P;	P = NULL;
}

bool bellman_ford::solve() {
	int current = 0;
	int minpath = INT_MAX;
	int unrelaxed = graphptr->numVertex;

	for (int i = 0; i < graphptr->numVertex; i++) {
 		D[i] = i==0?0:INT_MAX;					// odległość od wierzchołka = inf
		P[i] = i==0?-1:1;						// poprzedniki
	}
	D[0] = 0;									// zeruje odleglosc do początkowego węzła
	P[0] = -1;

	for (int k = 0; k < graphptr->numVertex - 1; k++) {	
		for (int i = 0; i < graphptr->numVertex; i++) {	
			for (int j = 0; j < graphptr->numVertex; j++) {	
				if ( graphptr->weight(i,j) < INT_MAX && D[i] < INT_MAX && D[j] > D[i] + graphptr->weight(i,j) ) {
					D[j] = D[i] + graphptr->weight(i,j);
					P[j] = i;
				}
			}
		}
	}

	solved = 1;
	
	return !negativeWeightCycle();				// TRUE if graph has no negative cycle
}

bool bellman_ford::negativeWeightCycle() {
	for (int i = 0; i < graphptr->numVertex; i++) {	
		for (int j = 0; j < graphptr->numVertex; j++) {	
			if ( graphptr->weight(i,j) < INT_MAX && D[i] < INT_MAX && D[j] > D[i] + graphptr->weight(i,j) ) {
				return 1;
			}
		}
	}
	return 0;
}

int bellman_ford::showCost(int target){
	if (solved) {
		return D[target-1];
	}
	else {
		return INT_MAX;
	}
}

void bellman_ford::showPath(int target){
	if (solved) {
			stack <int> rev;
	
			int ptr = target - 1;
		
			while ( ptr != -1  ) {
				rev.push(ptr);
				ptr = P[ptr];
		
			} 
		
			while ( !rev.empty() ) {
				cout << rev.top() + 1 << " ";
				rev.pop();
			}
		
			cout << endl;
	}
	else {
		cout << "solve first!";
	}
}
