/*
 *	Dijkstra's Algorithm v1.0
 *	Copyright (C) 2007 by Karol Kozłowski
 *	
 */

#include <spa.h>
#include <stack>

#include <graph.h>
#include <dijkstra.h>

dijkstra::dijkstra(graph* g){
	solved = 0;
	graphptr = g;
	
	Q = new int[graphptr->numVertex];
	D = new int[graphptr->numVertex];
	P = new int[graphptr->numVertex];

}

dijkstra::~dijkstra(){
	delete [] Q;	Q = NULL;
	delete [] D;	D = NULL;
	delete [] P;	P = NULL;
}

bool dijkstra::solve() {
	int current = 0;
	int minpath = INT_MAX;
	int unrelaxed = graphptr->numVertex;
	
	for (int i = 0; i < graphptr->numVertex; i++) {
		D[i] = i==0?0:INT_MAX;					// odległość od wierzchołka = inf
		Q[i] = 1;								// tablica wierzchołków nierozpatrzonych
		P[i] = i==0?-1:1;						// poprzedniki
	}
	
	while (unrelaxed > 0) {
		
		minpath = INT_MAX;
		
		for (int i = 0; i < graphptr->numVertex; i++) {	// po wszystkich wierzchołkach
			if (Q[i] == 1 && D[i] < minpath) {	// jeżeli nie rozpatrzony i ścieżka do niego jest najmniejsza
				current = i;					// rozpatrz węzeł z najmniejszą wagą
				minpath = D[i];
			}	
		}
		
		Q[current] = 0;							// oznacz węzeł jako rozpatrzony (uzuń ze zbioru)
		unrelaxed--;							// zmniejsz ilość nierozpatrzonych węzłów
			
		for (int i = 0; i < graphptr->numVertex; i++) {	// po wszystkich wierzchołkach
			if ( Q[i] == 1 && graphptr->weight(current, i) > 0 && graphptr->weight(current, i) < INT_MAX ) {	// następniki nierozpatrzone
				if ( D[i] > D[current] + graphptr->weight(current, i) ) {
					D[i] = D[current] + graphptr->weight(current, i);
					P[i] = current;
				}
			}
		}
	}
	
	#ifdef DEBUG
		cout << "Q = [ ";
		for (int i = 0; i < graphptr->numVertex; i++) {
			cout << Q[i] << " ";		
		}
		cout << " ]" << endl;
		cout << "D = [ ";
		for (int i = 0; i < graphptr->numVertex; i++) {
			cout << D[i] << " ";		
		}
		cout << " ]" << endl;
		cout << "P = [ ";
		for (int i = 0; i < graphptr->numVertex; i++) {
			cout << P[i] << " ";		
		}
			cout << " ]" << endl;
	#endif

	solved = 1;
}

int dijkstra::showCost(int target) { 
	if (solved) {
		return D[target-1];
	}
	else {
		return INT_MAX;
	}
}

void dijkstra::showPath(int target) { 
	if (solved) {
		
		stack <int> rev;
	
		int ptr = target - 1;
		
		while ( ptr != -1  ) {
			rev.push(ptr);
			ptr = P[ptr];
		
		} 
		
		while ( !rev.empty() ) {
			cout << rev.top() + 1 << " ";
			rev.pop();
		}
		
		cout << endl;
	}
	else {
		cout << "solve first!";
	}
}

