/*
 *	Floyd-Warshall Algorithm v1.0
 *	Copyright (C) 2007 by Karol Kozłowski
 *	
 */

#include <spa.h>
#include <stack>
#include <graph.h>
#include <floyd_warshall.h>

floyd_warshall::floyd_warshall(graph* g) {
	solved = 0;
	graphptr = g;
	
	D = new int*[graphptr->numVertex];
	P = new int*[graphptr->numVertex];
	
	for (int i = 0; i < graphptr->numVertex; i++) {
		D[i] = new int[graphptr->numVertex];
		P[i] = new int[graphptr->numVertex];
	}

}

floyd_warshall::~floyd_warshall() {
	for (int i = 0; i < graphptr->numVertex; i++) {
		delete [] D[i];		D[i] = NULL;
		delete [] P[i];		P[i] = NULL;
	}
	
	delete [] D;	D = NULL;
	delete [] P;	P = NULL;
}


void floyd_warshall::solve() {
	for (int k = -1; k < graphptr->numVertex; k++) {	
		for (int i = 0; i < graphptr->numVertex; i++) {	
			for (int j = 0; j < graphptr->numVertex; j++) {	
				if (k == -1) {
					D[i][j] = graphptr->weight(i,j);
					
					if ( i == j || graphptr->weight(i,j) == INT_MAX) {
						P[i][j] = -1;
					} 
					else {
						P[i][j] = i;
					}
					
				}
				else if (D[i][k] < INT_MAX && D[k][j] < INT_MAX && D[i][j] > D[i][k] + D[k][j]) {
						D[i][j] = D[i][k]+D[k][j];
						P[i][j] = P[k][j];	
				}
				
			}
		}
	}
	
	solved = 1;
}

void floyd_warshall::showWeightMatrix() {
	if (solved) {
		for (int i = 0; i < graphptr->numVertex; i++) {	
			for (int j = 0; j < graphptr->numVertex; j++) {	
				int k;
				if (D[i][j] == INT_MAX)
					cout << "INF" << "\t";
				else
					cout << D[i][j] << "\t";

			}
			cout <<	endl;
		}
	}
}

int floyd_warshall::showCost(int source, int target) {
	if (solved) {
		return D[source-1][target-1];
	}
	else {
		return INT_MAX;
	}
}

void floyd_warshall::showPath(int source, int target) {
	if (solved) {
		#ifdef DEBUG
		for (int i = 0; i < graphptr->numVertex; i++) {	
			for (int j = 0; j < graphptr->numVertex; j++) {	
				if (P[i][j] == -1)
					cout << "NIL" << "\t";
				else
					cout << P[i][j] << "\t";
			}
			cout <<	endl;
		}
		#endif
		
		stack <int> rev;
		
		int ptr = target - 1;
		
		while ( ptr != -1  ) {
			rev.push(ptr);
			ptr = P[source-1][ptr];
		
		} 
		
		while ( !rev.empty() ) {
			cout << rev.top() + 1 << " ";
			rev.pop();
		}
		
		cout << endl;		
		
	}
}

