/*
 *	Ford-Fulkerson Algorithm v1.0
 *	Copyright (C) 2007 by Karol Kozłowski
 *	
 */

#include <spa.h>
#include <stack>
#include <graph.h>
#include <floyd_warshall.h>
#include <ford_fulkerson.h>

ford_fulkerson::ford_fulkerson(graph* g, int s, int t) {

	solved = 0;
	source = s;
	sink = t;
	graphptr = g;
	
	
	resid = new graph(g);
	flow = new graph(g->numVertex, g->numJoints, 0);
}

ford_fulkerson::~ford_fulkerson() {
	
	delete resid;
	delete flow;

}

void ford_fulkerson::solve() {
	
	while (true) {
		floyd_warshall flo(resid);
		flo.solve();
		
		if (flo.showCost(source, sink) == INT_MAX) {
			break; 
		}
			
		//znajdz minimalna wage
		int ptr = sink - 1;
		int prev = flo.P[source - 1][ptr];
		int min = INT_MAX;
		while ( ptr > 0  && prev > 0) {
			min = (resid->weight(prev,ptr)<min)?resid->weight(prev,ptr):min;
			ptr = prev; 
			prev = flo.P[source-1][ptr];
		}  
		
		// zmien wagi w drzewie
		ptr = sink - 1;
		prev = flo.P[source-1][ptr];
		
		while ( ptr > 0  && prev > 0) {
			flow->weight(prev, ptr, flow->weight(prev, ptr) + min);
			resid->weight(prev, ptr, resid->weight(prev, ptr) - min);
			if (resid->weight(prev, ptr) == 0) resid->weight(prev, ptr, INT_MAX);
			
			if (resid->weight(ptr, prev) == INT_MAX) resid->weight(ptr, prev, 0);
			resid->weight(ptr, prev, resid->weight(ptr, prev) + min);
			flow->weight(ptr, prev, flow->weight( ptr, prev) - min);
			
			ptr = prev; 
			prev = flo.P[source-1][ptr];
		}

	}
	solved = 1;
}

void ford_fulkerson::showResidualMatrix() {
	for (int i=0; i<resid->numVertex; i++) {
		for (int j=0; j<resid->numVertex; j++) {
			if (resid->weight(i, j) == INT_MAX)
				//cout << "NIL" << "\t";
				cout << "0" << "\t";
			else
				cout << resid->weight(i, j) << "\t";
		}
		cout << endl;
	}
}

void ford_fulkerson::showFlowMatrix() {
	for (int i=0; i<flow->numVertex; i++) {
		for (int j=0; j<flow->numVertex; j++) {
			if (flow->weight(i, j) == INT_MAX)
				//cout << "NIL" << "\t";
				cout << "0" << "\t";
			else if (flow->weight(i, j) <= 0)
				cout << "0" << "\t";
			else
				cout << flow->weight(i, j) << "\t";
		}
		cout << endl;
	}
}


int ford_fulkerson::showResults() {
	
	int sum = 0;
	
	for (int i = 0; i < resid->numVertex; i++) 
		if (flow->weight(i, sink-1) > 0 && flow->weight(i, sink-1)!=INT_MAX) sum += flow->weight(i, sink-1);
	
	return sum;	

}
