/*
 *	Shortest Path Algorithms (SPA) v0.3
 *	Copyright (C) 2007 by Karol Kozłowski, Piotr Komoniewski
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the
 *	Free Software Foundation, Inc.,
 *	59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <graph.h>
#include <dijkstra.h>
#include <bellman_ford.h>
#include <floyd_warshall.h>
#include <ford_fulkerson.h>

#include <cstdlib>
#include <iostream>

using namespace std;

int main(int argc, char *argv[]) {	
	
	char choice;

	cout << "Select:" << endl;
	cout << " D - Dijkstra's" << endl;
	cout << " B - Bellman-Ford" << endl;
	cout << " F - Floyd-Warshall" << endl;
	cout << " O - Ford-Fulkerson (flow)" << endl;
	cout << " X - EXIT" << endl;
	
	choice = cin.get();
	
	// Dijkstra's Algorithm
	if (tolower(choice) == 'd') {
		string filename;
		int v_joint;
		
		cout << endl << "selected: Dijkstra's algorithm" << endl;
		
		// Get filename
		cout << "Enter data file name: ";
		cin >> filename;

		// Initialize graph
		graph graf(filename);
		
		// Get target vertex
		cout << "Enter 'v' vertex: ";
		cin >> v_joint;
	
		dijkstra dij(&graf);
		dij.solve();
		if ( dij.showCost(v_joint) == INT_MAX ) {
			cout << "No path to given vertex" << endl;
		}
		else {
			cout << dij.showCost(v_joint) << endl;
			dij.showPath(v_joint);
			cout << endl;
		}
	}
	
	// Bellman-Ford Algorithm
	if (tolower(choice) == 'b') {
		string filename;
		int v_joint;

		cout << endl << "selected: Bellman-Ford algorithm" << endl;

		// Get filename
		cout << "Enter data file name: ";
		cin >> filename;

		// Initialize graph
		graph graf(filename);

		cout << "Enter 'v' vertex: ";
		cin >> v_joint;
		
		bellman_ford bel(&graf);
		if (bel.solve()) {
			if ( bel.showCost(v_joint) == INT_MAX ) {
				cout << "No path to given vertex" << endl;
			}
			else {
				cout << bel.showCost(v_joint) << endl;
				bel.showPath(v_joint);
				cout << endl;
			}
		}
		else {
			cout << "Path could not be determined - negative weight cycle detected!" << endl;
		}
	}
	
	// Floyd-Warshall Algorithm
	if (tolower(choice) == 'f') {
		string filename;
		int v_joint, u_joint;

		cout << endl << "selected: Floyd-Warshall algorithm" << endl;
		cout << "** assuming no negative weight cycles **" << endl;

		// Get filename
		cout << "Enter data file name: ";
		cin >> filename;
		
		// Initialize graph
		graph graf(filename);

		cout << "Enter 'u' vertex: ";
		cin >> u_joint;
		
		cout << "Enter 'v' vertex: ";
		cin >> v_joint;
		
		floyd_warshall flo(&graf);
		flo.solve();
		flo.showWeightMatrix();
		if ( flo.showCost(u_joint, v_joint) == INT_MAX ) {
			cout << "No path between given vertices" << endl;
		}
		else {
			cout << flo.showCost(u_joint, v_joint) << endl;
			flo.showPath(u_joint, v_joint);
			cout << endl;
		}
	}
	
	// Ford-Fulkerson Algorithm
	if (tolower(choice) == 'o') {
		
		string filename;
		int s_joint, t_joint;

		cout << endl << "selected: Ford-Fulkerson algorithm" << endl;

		// Get filename
		cout << "Enter data file name: ";
		cin >> filename;
		
		// Initialize graph
		graph graf(filename);

		cout << "Enter 's' vertex (source): ";
		cin >> s_joint;
		
		cout << "Enter 't' vertex: (sink): ";
		cin >> t_joint;
		
		ford_fulkerson fofu(&graf, s_joint, t_joint);
		fofu.solve();
		fofu.showFlowMatrix();
		int maxFlow = fofu.showResults();
		if (maxFlow <= 0 ) {
			cout << "Down low no flow!" << endl;
		}
		else {
			cout << endl << maxFlow << endl;
		}
	}
	
	return EXIT_SUCCESS;
}

