% [classif] = NeNet (dataset, layerset, transff, epocs)
%
% creates Neural Network classifier for k-fold cross validation
%
% dataset     - learning data set
% layerset - hidden layers configuration
% transf   - NN transfer functions
% epocs    - no. of NN epocs
%
% classif  - classifiers structure

function [classif] = NeNet (dataset, layerset, transff, epocs)

    [K, d, r] = size(dataset);

    for k = 1:K
        
        fprintf('[norm] Fold: %2.d\n', k);
        
        T = [];
        P = [];        
        Tt = [];
        Pt = [];
       
        % prepare learning data
        for j = 1:K            
            if ( j ~= k )
                T = [T dataset(j,:,r:r)];
                temp(:,:) = dataset(j,:,1:r-1);
                P = [P, temp'];
                % remove empty data
                if(T(size(T,2)) == Inf)
                    P = P(:,1:size(T,2)-1);
                    T = T(1:size(T,2)-1);
                end

            else
                Tt = [Tt dataset(j,:,r:r)];
                temp(:,:) = dataset(j,:,1:r-1);
                Pt = [Pt, temp'];
                % remove empty data
                if(Tt(size(Tt,2)) == Inf)
                    Pt = Pt(:,1:size(Tt,2)-1);
                    Tt = Tt(1:size(Tt,2)-1);
                end
            end
        end


        
        T = ind2vec(T);                         % prepare data for training

        in = r - 1;
        out = size(T,1);

        net = newff(minmax(P),[in layerset out], transff, 'traingdx','learngdm');  % Create feedforward backpropagation network
        %net = newlvq(minmax(P), 10, [1/3 1/3 1/3], 0.01, 'learnlv2');

        net.trainParam.epochs = epocs;
        net.trainParam.show = NaN;
        [net,tr] = train(net,P,T);

        Td = sim(net, Pt);
        
        classif(k,:) = struct('type', 'norm', 'train_index', K-k+1, 'network', net, 'trecord', tr, 'train_p', P , 'train_t', T, 'test_p', Pt, 'test_t', Tt, 'test_data', Td);
        
    end
end
