%% Bagging predictors quality of recognition comparison
% created by Karol Kozlowski, Karol Nikscin
% 

%% initalization

n_boots = 05;                               % number of bootstraps (default: )
epocs = 500;                                % network epocs
K = 5;                                     % number of cross validation folds (default: 10)

%% preparing data
S = load('iris.data');                     % load and prepare dataset (ok)
%S = load('wine.data');                     % load and prepare dataset (ok)
%S = load('tic-tac-toe.data');              % load and prepare dataset (poor)
%S = load('shuttle.tst');                   % load and prepare dataset (LARGE!)
%S = load('pima-indians-diabetes.data');    % load and prepare dataset ()

S = trim(S, 1);
%% creating classifiers

%load('iris_n05_e350_k10.mat');             % iris.data, n_boots=09, epocs=350, k=10
%load('pima-indians-diabetes_n05_e350_k10.mat');
%load('tic-tac-toe_n05_e350_k10.mat');      % tic-tac-toe.data, n_boots=09, epocs=350, k=10

bagging_create                              % comment this line to work on created data set

%% testing

display('testing');
tests = [];
for h = 1:K
    for t = 1:size(classifier2(1,1).test_t,2)

        fprintf('Testing (%d, %d)\n', h, t);
        
        y = classifier2(h,1).test_t(t);

        [y1, raw1] = test(classifier1, classifier1(h).test_p(:,t));
        [y2, raw2] = test(classifier2, classifier2(h,1).test_p(:,t));
    
        e1 = mean(sum(abs(raw1(:,y) - 1),2));                    
        e2 = mean(sum(abs(raw2(:,y) - 1),2));
        var1 = var(sum(abs(raw1(:,y) - 1),2));
        var2 = var(sum(abs(raw2(:,y) - 1),2));
        err = 0;
       
        if (y1 ~= y)
            err = err + 1;
        end

        if (y2 ~= y)
            err = err + 2;
        end    
    
        tests = [tests; y y1 y2 e1 e2 var1 var2 err];
    end
end
% Y, norm_y, bagg_y, norm_e, bagg_e, norm_var, bagg_var 
%tests

d = 5;
lo = min(mean(tests(:,4)) - d *mean(tests(:,6)),mean(tests(:,5)) - d *mean(tests(:,7)));
hi = max(mean(tests(:,4)) + d *mean(tests(:,6)),mean(tests(:,5)) + d *mean(tests(:,7)));
delta = 0.01*min(mean(tests(:,6)),mean(tests(:,7)));
x=lo:delta:hi;
y1=gaussmf(x,[mean(tests(:,6)) mean(tests(:,4))]);
y2=gaussmf(x,[mean(tests(:,7)) mean(tests(:,5))]);

%% plotting

subplot(1,1,1);
cla;                                        % clear plot
hold on;
plot(x,y1,'g')
plot(x,y2,'r')
hold off;

%display('press any key to display another plot');
%pause

%plot_train(classifier1);

%display('press any key to display another plot');
%pause

%plot_train(classifier2);
