% function [y, raw] = test(classif, T)
%
% T - test data
% classif - classifier structure
% 
% y - mean output
% raw - raw data output

function [y, raw] = test(classif, T)


    if (classif(size(classif,1)).type == 'norm')
        
        raw = [];
        for i = 1:size(classif,1)

            raw = [raw; sim(classif(i).network, T)'];
 
        end
        
        [a y] = max(mean(raw));
        
    elseif (classif(size(classif,1)).type == 'bagg')

                
        raw = [];
        for i = 1:size(classif,1)
            
            aggr = [];
            for j = 1:size(classif,2)
                aggr = [aggr; sim(classif(i,j).network,T)'];
            end
            
            raw = [raw; aggregate(aggr) ];
 
        end
        
        [a y] = max(mean(raw));
        
    else
        
        display('Que?');
        
    end

end
