echo off
v = version;
if strcmp(v(1),'S')
  disp('Benchmarks unavailable in Student Edition.')
  disp('Press any key to continue . . .')
  pause
  return
end
echo on
clc
%	The MATLAB benchmarks.          (May take 2-3 minutes)
%
%	This demo file runs a set of 7 standard benchmarks:
%
%		1) N=50 Real matrix multiply
%		2) N=50 Real matrix inverse
%		3) N=25 Real eigenvalues
%		4) 4096-point complex FFT
%		5) LINPACK benchmark 
%		6) 1000 iteration FOR loop
%		7) N=25 3-D mesh plot
%
%	The benchmarks illuminate computer architectural issues that
%	affect the speed of software like MATLAB on different machines.
%
%	The time for your machine is measured and displayed versus times
%	we've already taken from other standard machines. 

pause	% Hit any key to start benchmark measurements.
etime(1,1);
ts = zeros(1,7);
clc

rand('uniform'), rand('seed',0)
a = rand(50);

%	 50 by 50 real multiply

t=clock; 		b = a*a; ...
ts(1)=etime(clock,t);

clc,disp('Benchmarks:'),disp(' '),...
disp('     *        inv       eig       fft      LINPACK   for      mesh'),...
disp(ts(1))

 
%	N=50  real inverse

t=clock; 		b = inv(a); ...
ts(2)=etime(clock,t);

clc,disp('Benchmarks:'),disp(' '),...
disp('     *        inv       eig       fft      LINPACK   for      mesh'),...
disp(ts(1:2))


%	N=25 real eigenvalues

a = rand(25);
t=clock; 		b = eig(a); ...
ts(3)=etime(clock,t);

a=[];b=[];
clc,disp('Benchmarks:'),disp(' '),...
disp('     *        inv       eig       fft      LINPACK   for      mesh'),...
disp(ts(1:3))


%	4096 point complex FFT

a = rand(1,4096) + sqrt(-1);
t=clock; 		b = fft(a);...
ts(4)=etime(clock,t);

a=[];b=[];
clc,disp('Benchmarks:'),disp(' '),...
disp('     *        inv       eig       fft      LINPACK   for      mesh'),...
disp(ts(1:4))

%	N = 100 LINPACK Benchmark

[c,maxsize] = computer;
if maxsize < 8192		% If computer is limited to 90x90,
  t = dongarra(90);		% extrapolate 90 to 100
  ts(5) = t*(100^3/3 + 100^2)/(90^3/3 + 90^2);
else
  ts(5) = dongarra(100);	% N=100 LINPACK for other computers
end

clc,disp('Benchmarks:'),disp(' '),...
disp('     *        inv       eig       fft      LINPACK   for      mesh'),...
disp(ts(1:5))


%	1000 FOR loops

a(1000) = 0;
t = clock; 		for i=1:1000, a(i) = 1; end,...
ts(6) = etime(clock,t);

clc,disp('Benchmarks:'),disp(' '),...
disp('     *        inv       eig       fft      LINPACK   for      mesh'),...
disp(ts(1:6))


%	N=25 mesh plot

a = eye(25); t = clock; mesh(a); ts(7) = etime(clock,t);

echo off
times = [
	76	101	107	91	256	17	66
	12.1	19.5	17.5	13.7	45.8	2.97	 9.1
	9.45	20.9	21.0	12.3	40.9	18.0	15.8
	5.2	11.6	11.2	 7.1	23.5	8.7	 7.4
	1.95	3.52	2.82	3.33	8.1	0.62	5.0
	2.6	4.5	3.7	3.5	9.5	0.69	4.3
	1.84	3.6	3.4	 3.5	7.7	2.0	 5.0
	1.31	3.0	1.74	1.89	4.9	0.87	2.2
	2.6	3.1	2.9	 2.9	4.9	3.2	25.0
	1.05	2.0	2.42	2.15	4.08	0.52	3.22
	0.71	1.32	1.21	1.16	2.96	0.93	1.87
	0.76	1.42	1.38	1.8	3.46	1.02	3.9
	0.8	1.09	0.86	0.79	1.88	0.49	1.26
	0.34	0.72	0.98	 .94	1.4	0.9	 2.0
	0.22	0.43	0.44	0.4	0.94	0.36	1.5
	0.125	0.25	0.28	0.3	0.48	0.13	1.32
	.07	.28	.54	.37 	.19	.34	.69
	ts];
[m,n] = size(times);	% Number of benchmarked machines
clc
disp('		------- Table of benchmark times -------')
disp(' ')
disp('			1) Macintosh (8MHz 68000)')
disp('			2) PC/AT (6.0MHz/80286/EGA)')
disp('			3) PC/XT (4.7MHz/8088/CGA)')
disp('			4) AT&T 6300 (8MHz/8086)')
disp('			5) Macintosh II (68020/68881)')
disp('			6) Apollo DN3000 (16MHz)')
disp('			7) Sun-3/50 (15MHz with 68881)')
disp('			8) Apollo DN4000 (25MHz)')
disp('			9) Your machine')
disp(' ')
disp('     *        inv       eig       fft     LINPACK     for       mesh')
disp([times(1:8,:); times(m,:)])
disp('Strike any key to continue'), pause
clc
disp('		------- Table of benchmark times (continued) -------')
disp('			 9) MicroVAX II (VMS/D_floating)')
disp('			10) Macintosh IIcx (68030/68882)')
disp('			11) 80386/80387 (20MHz, 386-MATLAB)')
disp('			12) Sun-386i (25MHz)')
disp('			13) VAXStation 3100 (VMS/D_floating)')
disp('			14) Sun-3/260 (25MHz with FPA)')
disp('			15) Sun-4/110')
disp('			16) Sun SparcStation')
disp('			17) Ardent Titan')
disp('			18) Your Machine')
disp('     *        inv       eig       fft       LINPACK   for       mesh')
disp(times(9:m,:))
disp('Strike any key to continue'), pause
ratio = ones(m,1)*times(3,:)./times;
clc
disp('		------- Table of speed ratios to PC/XT -------')
disp(' ')
disp('			1) Macintosh (8MHz 68000)')
disp('			2) PC/AT (6.0MHz/80286/EGA)')
disp('			3) PC/XT (4.7MHz/8088/CGA)')
disp('			4) AT&T 6300 (8MHz/8086)')
disp('			5) Macintosh II (68020/68881)')
disp('			6) Apollo DN3000 (16MHz)')
disp('			7) Sun-3/50 (15MHz with 68881)')
disp('			8) Apollo DN4000 (25MHz)')
disp('			9) Your machine')
disp(' ')
disp('    *         inv       eig       fft       LINPACK   for       mesh')
disp([ratio(1:8,:); ratio(m,:)])
disp('Strike any key to continue'), pause
clc
disp('		------- Table of speed ratios to PC/XT (continued) -------')
disp('			 9) MicroVAX II (VMS/D_floating)')
disp('			10) Macintosh IIcx (68030/68882)')
disp('			11) 80386/80387 (20MHz, 386-MATLAB)')
disp('			12) Sun-386i (25MHz)')
disp('			13) VAXStation 3100 (VMS/D_floating)')
disp('			14) Sun-3/260 (25MHz with FPA)')
disp('			15) Sun-4/110')
disp('			16) Sun SparcStation')
disp('			17) Ardent Titan')
disp('			18) Your Machine')
disp('    *         inv       eig       fft       LINPACK   for       mesh')
disp(ratio(9:m,:))
disp('Strike any key to continue'), pause
merit = prod(ratio').^(1/n);
clc
disp(' To combine these numbers into a single "figure of merit" for')
disp(' each machine, we compute the geometric mean. Here are the results:')
disp(' ' )
disp('    Mac       PC/AT     PC/XT     6300      Mac II    DN3000    Sun-3')
disp(merit(1:7))
disp('    DN4000    MicroVAX  Mac IIcx 386/387    Sun-386i VAX3100   Sun-3/FPA')
disp(merit(8:14))
disp('   Sun-4     Sparc     Titan     Your Machine')
disp(merit(15:m))
disp('Strike any key to continue'), pause
clc
disp('Another popular number to look at is the number of KFlops obtained')
disp('from Jack Dongarra''s LINPACK benchmark (sometimes called the Argonne')
disp('benchmark).  This number is often advertised by computer manufacturers')
disp('in national trade magazines, comparing their computer versus others')
disp('in terms of floating point performance.')
disp(' ' )
disp('The LINPACK benchmark compares the performance of different computer')
disp('systems while solving 100''th order dense systems of linear equations in')
disp('a Fortran environment.   We''re in a C environment, but this doesn''t')
disp('stop us from performing the equivalent calculation.')
disp(' ')
disp('Strike any key to continue'), pause
clc

disp('For solving a system of 100 equations, approximately')
disp(' ')
disp('nflops = 2/3*100^3 + 2*100^2')
nflops = 2/3*100^3 + 2*100^2
disp('operations are performed.  Using our times from above, we find the')
disp('KFlop/second throughput for the various machines:')

KFlops = round(nflops./times(:,5)'/1000);
disp(' ')
disp('    Mac   AT    XT   6300 Mac II  DN3  Sun-3 DN4   MVAX  IIcx  387  S386i')
disp(KFlops(1:12))
disp('        VAX3100     S3/FPA      Sun-4       Sparc       Titan   Your Machine')
disp(KFlops(13:m))
disp('Just for reference, the Cray X-MP achieves 33,000 KFlops!')
disp(' ')
disp('Strike any key to continue'), pause
