echo on
clc
%	   A well known fact from systems theory is that convolution in the
%	time domain is equivalent to multiplication in the frequency domain.
%	We can show this numerically with MATLAB using the FFT and the
%	CONV functions.

%	We start by forming two sequences of numbers to work with, arbitrarily
% 	selecting sequences of integers:

x = [1 2 3 4]
y = [5 4 3 2 1]

pause % Strike any key to continue.
clc
% 	Convolving them in the time domain is easy, we just use the 
% 	convolution operator:

ztime = conv(x,y)

pause % Strike any key to continue.
clc
%	To multiply the sequences in the frequency domain, the sequences
%	first need to be transformed to a frequency domain representation.
%	We use FFTs to calculate the discrete Fourier transforms.  The final
%	sequence length of z will be eight, so the vectors x and y must be
%	padded with zeros to make them length eight. We can then FFT them,
%	multiply, and inverse FFT:

x = [x 0 0 0 0];
y = [y 0 0 0];

X = fft(x);
Y = fft(y);
XY = X.*Y;
zfreq = real(ifft(XY));

pause % Strike any key to continue.
clc
%	Comparing the FFT result with the convolution result:

ztime
round(zfreq)

%	we see that the two are indeed the same, within roundoff error.
%	For this display, the frequency results have been rounded to remove 
%	a small amount of rounding error from the FFT algorithm. 

pause % Strike any key to continue.
clc
%	We can look at the error by examining the difference between the
%	convolution results and the FFT results:

ztime - zfreq

%	and the maximum residual is about 1.7e-15.

pause % Strike any key to continue.
echo off
clc
