function A = eigmovie(A)
%EIGMOVIE Symmetric eigenvalue movie.
%	EIGMOVIE(A) shows a "movie" that depicts the computation of
%	the eigenvalues of a symmetric matrix.

n = max(size(A));
mflag = strcmp(computer,'SUN') | strcmp(computer,'APOLLO') | strcmp(computer,'MAC2');
if n > 7
   disp('Sorry, only 7 by 7 or smaller on this screen')
else
   clc
   home
   disp('Symmetrized input matrix')
   A = (A + A')/2
   if mflag, mesh(A), end
   I = eye(A);

   for k = 2:n-1
      home
      disp(['Householder similarity transformation ' int2str(k-1)]) 
      u = A(:,k-1);
      u(1:k-1) = zeros(k-1,1);
      u = u/norm(u);
      if u(k) < 0, u = -u; end
      u(k) = u(k) + 1;
      beta = -u(k);  % -(norm(u)^2)/2
      v = A*u/beta;
      gamma = v'*u/(2*beta);
      v = v + gamma*u;
      A  =  A + u*v' + v*u';
      j = (k+1):n;  z = zeros(n-k,1);
      A(j,k-1) = z;  A(k-1,j) = z';
      A
      if mflag, mesh(A), end
   end
   home
%  disp(['*** pause ***' blanks(27)]),  pause

   it = 0;
   while n > 1
      home
      disp(['Symmetric tridiagonal QR iteration ' int2str(it) '   '])
      d = diag(A); e = diag(A,-1);
      A = diag(d) + diag(e,-1) + diag(e,1)
      if mflag, mesh(A), end
      k = n-1:n;
      format long
      S = A(k,k)
      if mflag, mesh(A), end
      format
      if abs(S(2,1)) < eps*(abs(S(1,1)) + abs(S(2,2)))
         A(n,n-1) = 0;  A(n-1,n) = 0;
         n = n-1;
      else
         shift = eig(S);
         if abs(shift(1)-A(n,n)) < abs(shift(2)-A(n,n))
            shift = shift(1); else, shift = shift(2); end
         [Q,R] = qr(A-shift*I);
         A = R*Q+shift*I;
      end
      it = it + 1;
   end
end
