echo on
clc
%	It is possible to make "movies" showing the running progress
%	of matrix computations.  There is an M-file on disk called
%	RREF that computes the reduced row echelon form of a matrix.
%	We have copied it to RREFMOVIE and inserted some commands to
%	display the intermediate results.

%	Suppose we start with a magic square of order 6:

a = magic(6)
pause	% Strike any key to continue.
clc

%	This matrix of order 6 has a rank of:

rank(a)
pause	% Strike any key to continue.
clc

%	Now let's start a movie showing the progress of the RREF algorithm.
%	Watch as the matrix is cleared out using row and column operations.

pause	% Strike any to start movie.

rrefmovi(a);

pause	% Strike any key to continue.
clc

%	This completes the RREF "movie".  The next movie we'll show you
%	illustrates an algorithm for finding the eigenvalues of a symmetric
%	matrix.

%	Consider the following matrix, whose eigenvalues are approximately the
%	diagonal elements:

e = ones(6,1);
T = diag(e,1) + diag(e,-1);
A = T + 10*diag(abs(-3:3))
pause	% Strike any key to continue.
clc
%	We now "hide" the eigenvalues, by giving the matrix a random 
%	orthogonal similarity transformation:

Q = orth(rand(A));
A = Q'*A*Q
pause	% Strike any key to continue.

%	Now let's start a movie showing the progress of an
%	eigenvalue algorithm:

e = eigmovie(A);
e = diag(e)		% Here are the eigenvalues:
pause	% Strike any key to continue.
clc
%	Consider the Hilbert matrix of order 5:

A = hilb(5)
%	The Hilbert matrix is a famous example of a badly
%	conditioned matrix.  This 5x5 example has condition
%	number

c = cond(A)
pause	% Strike any key to continue.
clc
%	A Hilbert matrix has elements a(i,j) = 1/(i+j-1).  We
%	can see this more clearly using MATLAB's rational output
%	format:

rat(A,'s')
pause	% Strike any key to continue.

%	Let's start a movie that computes the reduced row-echelon
%	form of this Hilbert matrix, all in rational format:

pause	% Strike any to start movie.

R = ratmovie(A)
pause	% Strike any key to continue.
