program testls;

{ Author: Charles D. Packard
          The Mathworks, Inc.
  Date:   8 April 89

  Known to work with Borland Turbo Pascal v5.0
     (will not work with earlier versions because they do not
      support IEEE standard 8-byte double precision real numbers)

}
{$N+} {use Intel 80x87, must be around if using MATLAB and allows
       us to use double precision real numbers}

{For a complete explanation of the format of a MATLAB data (.mat)
 file, see load and save in the MATLAB User's Guide Reference
 section.}

type
    HeadRec = record           {contents of standard 20 byte header}
            mattype : longint; {describes machine that created mat file}
            matrows : longint; {number of rows in data set}
            matcols : longint; {number of columns in data set}
            imagef  : longint; {1 if data set is complex, 0 if not}
            namelen : longint; {number of characters in array name, +1 for
                                the 0-byte used to end array string in C}
    end;
   Buffer = array[1..500] of double; {rough estimate of needs, make smaller}
                                     {or larger as needed }
   NameStr = array[1..20] of char;   {the name of the next variable in file}

var
   in_file, out_file : file; {Untyped files becuase of binary format}
   header : HeadRec;
   name   : NameStr;         {character array to hold name of variable}
   realp  : Buffer;          {real part of array of double precision numbers}
   imagep : Buffer;          {imaginary part of array}
   i, j : integer;           {working variables}
   ZeroByte : byte;          {need to simulate a C text string terminator \0}


{LOADMAT - a Pascal procedure to read a MATLAB data file}
procedure loadmat(var in_file : file;                {see TESTLS for types used}
                  var header  : HeadRec;
                  var name    : NameStr;
                  var realp   : Buffer;
                  var imagep  : Buffer);

var
   i, j : integer;                  {working variables}
   ZeroByte : byte;                 {need to take care of C's string terminator}

begin
blockread(in_file, header, 20);                     {read in header information}
blockread(in_file, name, header.namelen - 1);       {we won't read in 0 byte}
blockread(in_file, ZeroByte, 1);            {read in 0 byte C string terminator}
blockread(in_file, realp, 8*header.matcols*header.matrows);    {read in numbers}
if header.imagef = 1 then           {only need read imaginary part if it exists}
   blockread(in_file, imagep, 8*header.matcols*header.matrows); 
end;


{SAVEMAT - a Pascal procedure to write out a MATLAB data file}
procedure savemat(var out_file : file; {see TESTLS for types used}
                       header  : HeadRec;
                       name    : NameStr;
                       realp   : Buffer;
                       imagep  : Buffer);

var
   i, j : integer; {working variables}

const
   ZeroByte : byte = 0; {NUL terminator in a C character string}
   
begin
blockwrite(out_file, header, 20);                 {write out header information}
blockwrite(out_file, name, header.namelen-1);     {write out name of variable}
blockwrite(out_file, ZeroByte, 1);        {need to make it look like a C string}
blockwrite(out_file, realp, 8*header.matcols*header.matrows);  {write real part}
if header.imagef = 1 then                {write out imaginary part if it exists}
   blockwrite(out_file, imagep, 8*header.matcols*header.matrows);
end;


{ TESTLS - A Pascal language program to show use of LOADMAT and SAVEMAT
           routines to work with MATLAB data files}
begin
assign(in_file, 'foo.mat');      {create this trial MATLAB data before running}
reset(in_file, 1);               {record length of 1 byte}

assign(out_file, 'pascal.mat');              {we will create this new data file}
rewrite(out_file, 1);

loadmat(in_file,  header, name, realp, imagep);     {read in MATLAB data file}
savemat(out_file, header, name, realp, imagep);     {write out MATLAB data file}

{NOTE:
   Could have put the calls to the above routines in a loop checking
   for end of file condition to read in a data file with un-known
   number of variables in it or a for loop if knew how many.}
end.

