function A = compan (c)
%COMPAN  COMPAN(P) is a companion matrix of the polynomial with
%	coefficients P.
n = size(c);
if ~sum(n == 1)
	error('Input argument must be a vector')
end
n = max(n);
c = c(:).';		% make sure it's a row vector
A = 1;
if  n ~= 2
	A = diag(ones(1,n-2),-1);
end
A(1,:) = -c(2:n) ./ c(1);
