function e = expm(a)
% Matrix exponential via Pade approximation.
% (This is the algorithm the built-in expm uses.)
% See Golub and Van Loan, Matrix Computations, Algorithm 11.3-1.
%
% Scale A by power of 2 so that its norm is < 1/2 .
s = norm(a,'inf');
if s > 0, s = max(0,fix(log(s)/log(2))+2); end
a = a/2^s;

% Pade approximation for exp(A)
X = a; 
[n,n] = size(a);
c = 1/2;
e = eye(n) + c*a;
d = eye(n) - c*a;
q = 6;
p = 1;
qp1 = q + 1;
q2p1 = 2*q + 1;
for k = 2:q
 % c = c * (q-k+1) / (k*(2*q-k+1));  The following line is a little faster:
   c = c * (qp1-k)   / (k*(q2p1-k));
   X = a*X;
   cX = c*X;
   e = e + cX;
   if p
     d = d + cX;
   else
     d = d - cX;
   end
   p = ~p;
end
e = d\e;

% Undo scaling by repeated squaring
for k=1:s, e = e*e; end

