function F = funm(A,fun)
%FUNM	Evaluate matrix functions.  For matrix arguments A,
%	FUNM(A,'fun') evaluates the matrix function specified by
%	fun.   For example, FUNM(A,'exp') calculates the matrix
%	exponential, FUNM(A,'log') the matrix logarithm, and
%	FUNM(A,'sqrt') the matrix square root.  For matrix
%	exponentials, EXPM is better.

%	C.B. Moler 12-2-85
%	Last Revised 7-21-86 CBM
%	Copyright (c) 1985, 1986 by the MathWorks, Inc.

%	 Parlett's method.  See Golub and VanLoan (1983), p. 384.

[Q,T] = schur(A);
[Q,T] = rsf2csf(Q,T);
F = eval(['diag(',fun,'(diag(T)))']);
tol = eps*norm(T,1);
n = max(size(A));
for p = 1:n-1
   for i = 1:n-p
      j = i+p;
      s = T(i,j)*(F(j,j)-F(i,i));
      if p > 1
         k = i+1:j-1;
         s = s + T(i,k)*F(k,j) - F(i,k)*T(k,j);
      end
      d = T(j,j) - T(i,i);
      if abs(d) <= tol,
         disp('WARNING: Result from FUNM is probably inaccurate.')
         d = tol;
      end
      F(i,j) = s/d;
   end
end
F = Q*F*Q';
