function [x]=hilb(n)
%HILB	Hilbert matrix.  HILB(N)  is the N by  N   matrix  with
%	elements  1/(i+j-1), which is a famous example of a badly
%	conditioned matrix.   See INVHILB for the exact inverse.
x = ones(n);
for i=1:n
	for j=1:n
		x(i,j) = (1)./(i+j-1);
	end
end
