function y = linspace(d1, d2, n)
%LINSPACE Generate linearly spaced vector.
%	LINSPACE(x1, x2) generates a row vector of 100 linearly
%	equally spaced points between x1 and x2.
%	LINSPACE(x1, x2, N) generates N points between x1 and x2.
%	See also LOGSPACE and :.

%	Copyright (c) 1989 by the MathWorks, Inc.

if nargin == 2
	n = 100;
end
y = [d1+(0:n-2)*(d2-d1)/(n-1) d2];
