function polarbar(x,period,s)
% POLARBAR Polar bar plot
%	POLARBAR shows vector information as
%	thin rectangular bars emanating from the origin.
%	POLARBAR(X,PERIOD,'S') makes a polar bar plot of real vector
%	X, distributed around a circle with the given PERIOD.  'S'
%	is the desired line type.  PERIOD defaults to the length
%	of X.  'S' defaults to 'r-'.
%
%	Example: rand('uniform'), polarbar(rand(20,1))

%	Charles R. Denham, , December 8, 1989.
%	Copyright, The MathWorks, Inc. 1990.

x = x(:).';
n = length(x);

if nargin == 2
   if isstr(period)
      s = period;
      period = n;
     else
      s = 'r-';
   end
  elseif nargin == 1
   period = n;
   s = 'r-';
end

mx = max(x);

delta = 2 .* pi ./ period;
ang = sqrt(-1) .* delta .* (0:5) ./ 5;
w = [0 exp(ang) 0];

z = [];
delta = exp(sqrt(-1) .* delta);
for i = 1:n
   z = [z (w .* x(i))];
   w = w .* delta;
end

axis('square')
a = ((0:4) + 1./2) ./ 4;
sq = sqrt(2) .* exp(-sqrt(-1) .* 2 .* pi .* a);
sq = sq .* mx;
plot(real(sq), imag(sq), 'w:', real(z), imag(z), s);
axis('normal')
