function quiver(x,y,s)
%QUIVER	Quiver plot.
%	QUIVER(Z) draws a graph that displays the angle and magnitude
%	of the complex elements of Z as arrows emanating from equally
%	spaced grid positions, one arrow per matrix element.
%
%	QUIVER(X,Y) is equivalent to QUIVER(X+i*Y).  It displays the
%	quiver plot for the angles and magnitudes of the elements of
%	matrices X and Y.
%
%	QUIVER(Z,'S') and QUIVER(X,Y,'S') use line style 'S' where
%	'S' is any legal linetype as described under the PLOT command.
%
%	For example, try
%	   [x,y] = meshdom(-2:.2:2, -2:.2:2);
%	   z = x .* exp(-x.^2 - y.^2);
%	   [px,py] = gradient(z,.2,.2);
%	   contour(z),hold on, quiver(px,py), hold off
%
%	See also GRADIENT, COMPASS, FEATHER, and ROSE.

%	Charles R. Denham, MathWorks 3-20-89
%	Copyright (c) 1989 by the MathWorks, Inc.

xx = [0 1 .8 1 .8].';
yy = [0 0 .08 0 -.08].';
arrow = xx + yy.*sqrt(-1);

if nargin == 2
   if isstr(y)
      s = y;
      y = imag(x); x = real(x);
     else
      s = 'r-';
   end
  elseif nargin == 1
   s = 'r-';
   y = imag(x); x = real(x);
end

[m,n] = size(x);
[xx,yy] = meshdom(1:n, 1:m);
grid = xx + yy.*sqrt(-1); grid = grid(:);
x = x(:); y = y(:);
z = (x + y.*sqrt(-1)).';
scale = 0.90 ./ max(max(abs(z)));
a = scale * arrow * z + ones(5,1) * grid.';
plot(real(a), imag(a), s);

