function rose(x,y,nbins,s)
%ROSE	Angle histogram, also known as a Rose plot.
%	ROSE(Z) plots a circular histogram showing the distribution
%	of the angles of the complex data in matrix Z.  The default
%	number of bins is 36.
%
%	ROSE(X,Y) is equivalent to ROSE(X+i*Y).  It plots the angle
%	histogram of ATAN2(Y,X), the angles specified by the elements
%	of matrices X and Y.
%
%	ROSE(Z,N) and ROSE(X,Y,N), where N is a scalar, uses N bins.
%	ROSE(...,'S') uses line style 'S' where 'S' is any legal
%	linetype as described under the PLOT command.
%
%	See also COMPASS, FEATHER, and QUIVER.

%	Charles R. Denham, MathWorks 3-20-89
%	Copyright (c) 1989 by the MathWorks, Inc.

a = ((0:4) + 1./2) ./ 4;
sq = sqrt(2) .* exp(-sqrt(-1) .* 2 .* pi .* a);

xx = [0 1 .8 1 .8].';
yy = [0 0 .08 0 -.08].';
arrow = xx + yy.*sqrt(-1);

bindef = 36; sdef = 'r-';

if nargin == 3
   if isstr(nbins) & any(imag(x))
      s = nbins;
      nbins = y;
      y = imag(x); x = real(x);
     elseif isstr(nbins)
      s = nbins;
      nbins = bindef;
     else
      s = sdef;
   end
  elseif nargin == 2
   if isstr(y)
      s = y;
      nbins = bindef;
      y = imag(x); x = real(x);
	elseif any(imag(x))
		nbins = y;
		y = imag(x);
		x = real(x);
		s = sdef;
     else 
      s = sdef;
      nbins = bindef;
   end
  elseif nargin == 1
   s = sdef;
   nbins = bindef;
   y = imag(x); x = real(x);
end

x = x(:);
y = y(:);
if length(x) ~= length(y)
   error('X and Y must be same length.');
end

[m,n] = size(x);

z = x + y.*sqrt(-1);
a = angle(z);
bins = [-nbins/2:nbins/2] .* 2 .* pi ./ nbins;
f = zeros(1,nbins+1);
for i = 2:nbins+1, f(i) = sum(a <= bins(i)); end
j = 1:nbins; f = f(j+1)-f(j); mx = max(max(f));

delta = 2 .* pi ./ nbins;
ang = delta .* (0:5) ./ 5;
w = [0 ang 0];
k = length(w);

d = ones(k,1) * (0:nbins-1) .* delta - pi;
z = (w.' * ones(1,nbins)) + d;
z = exp(sqrt(-1) .* z);
z(1:k-1:k,:) = zeros(2,nbins);
y = ones(k,1) * f;
z = z .* y;
axis('square')
sq = sq .* mx;
plot(real(sq), imag(sq), 'w:', real(z), imag(z), s);
axis('normal')
