function [z,p,k] = buttap(n)
%BUTTAP	Butterworth analog lowpass filter prototype.
%	[Z,P,K] = BUTTAP(N) returns the zeros, poles, and gain
%	for an N-th order normalized prototype Butterworth analog
%	lowpass filter.  The resulting filter has N poles around
%	the unit circle in the left half plane, and no zeros.
%
%	See also BUTTER, CHEB1AP, and CHEB2AP.

%	J.N. Little and J.O. Smith 1-14-87
%	Revised 1-13-88 LS
%	Copyright (c) 1987-91 by the MathWorks, Inc.

% Poles are on the unit circle in the left-half plane.
z = [];
p = exp(sqrt(-1)*(pi*(1:2:2*n-1)/(2*n) + pi/2)).';
k = real(prod(-p));

