function [k,t]=pcf
% Przeksztalcenie calkowe Fouriera
% [k,t]=pcf
load ysi.mat;
clc;disp(' Przeksztalcenie calkowe Fouriera');disp('');
n=input('Podaj liczbe skladowych z aproksymacji: n = ');disp('');
disp(' Podaj parametry aproksymacji - n liczb w nawiasach ');
disp(' kwadratowych odzielone spacjami:');
ro=input(' [ro1 ro2 ... ron] = ');disp('');
wd=input(' [fd1 fd2 ... fdn] (w kHz) = ');disp('');
wo=input(' [fo1 fo2 ... fon] (w kHz) = ');disp('');
disp(' Wyznaczona zostanie odpowiedz ukladu na skok jednostkowy 1(t)');
disp(' w przedziale czasu od 0 do tk z krokiem dt. Podaj: ');
tk=input(' tk (w ms) = ');
dt=input(' dt (w ms) = ');
%input('Czy cos poprawic ? (t/n) ','s');
%if ans=='t'
%  disp('Wyjscie: Ctrl+z');keyboard
%end
%!del cw9
%fprintf('cw9','  Przeksztalcenie calkowe Fouriera\n\n');
%fprintf('cw9','  Liczba skladowych: n = %g\n\n',n);
%fprintf('cw9','  i     ro(i)     fd(i)     fo(i)\n\n',n);
%for i=1:n
%  fprintf('cw9','  %g    %6.3f',i,ro(i));
%  fprintf('cw9','    %6.3f    %6.3f\n',wd(i),wo(i));
%end
%fprintf('cw9','\n  tk = %6.3f [ms]\n\n  dt = %6.3f [ms]\n',tk,dt);
% disp('Sprawdz drukarke i nacisnij dowolny klawisz!');
% !print cw9
disp('');disp(' Obliczenia !');
t=0:dt:tk;m=max(size(t));k=zeros(size(t));h=zeros(size(t));
wd=2*pi*wd;wo=2*pi*wo;
for i=1:n
  roi=ro(i);wdi=wd(i);woi=wo(i);
  for j=1:m
    tp=t(j);
    if tp > 0
      sip=si(wdi*tp,y_150);
      yp=sip+woi/(woi-wdi)*(si(woi*tp,y_150)-sip);
      yp=yp+(cos(woi*tp)-cos(wdi*tp))/(tp*(woi-wdi));
      h(j)=yp*roi*2/pi;
    end
  end
  k=k+h;
end
%disp('');disp('Drukowanie wykresu przez Print Screen');
%disp('Przywrocenie wykresu za pomoca komendy: shg');
%disp('Nacisnij dowolny klawisz');
%clg;
plot(t,k),grid;
title('Charakterystyka jednostkowa');
xlabel('ms');ylabel('V');
