$NOMOD51
$INCLUDE(REG517.INC)

TAB1 EQU 30h		;Przypisuje nazw wartoci liczbowej
LICZNIK EQU 10	


LCD_WC EQU 0FF2Ch	;LCD Write Command
LCD_WD EQU 0FF2Dh	;LCD Write Data
LCD_RC EQU 0FF2Eh	;LCD Read Command
LCD_RD EQU 0FF2Fh	;LCD Read Data

RFLAG EQU 20h
  FL0 EQU RFLAG.0	
  FL1 EQU RFLAG.1	

ORG 0000
LJMP START

ORG 000bh

  PUSH ACC
  PUSH PSW

	MOV P5, #01111111b
	MOV A, P7

	JB ACC.0, KBA
	 MOV R0, #'A'
	 SETB FL0
	KBA:

	JB ACC.1, KB3
	 MOV R0, #'3'
	 SETB FL0
	KB3:

	JB ACC.2, KB2
	 MOV R0, #'2'
	 SETB FL0
	KB2:

	JB ACC.3, KB1
	 MOV R0, #'1'
	 SETB FL0
	KB1:

	MOV P5, #10111111b
	MOV A, P7

	JB ACC.0, KBB
	 MOV R0, #'B'
	 SETB FL0
	KBB:

	JB ACC.1, KB6
	 MOV R0, #'6'
	 SETB FL0
	KB6:

	JB ACC.2, KB5
	 MOV R0, #'5'
	 SETB FL0
	KB5:

	JB ACC.3, KB4
	 MOV R0, #'4'
	 SETB FL0
	KB4:

	MOV P5, #11011111b
	MOV A, P7

	JB ACC.0, KBC
	 MOV R0, #'C'
	 SETB FL0
	KBC:

	JB ACC.1, KB9
	 MOV R0, #'9'
	 SETB FL0
	KB9:

	JB ACC.2, KB8
	 MOV R0, #'8'
	 SETB FL0
	KB8:

	JB ACC.3, KB7
	 MOV R0, #'7'
	 SETB FL0
	KB7:

	MOV P5, #11101111b
	MOV A, P7

	JB ACC.0, KBD
	 MOV R0, #'D'
	 SETB FL0
	KBD:

	JB ACC.1, KBh
	 MOV R0, #'#'
	 SETB FL0
	KBh:

	JB ACC.2, KB0
	 MOV R0, #'0'
	 SETB FL0
	KB0:

	JB ACC.3, KBs
	 MOV R0, #'*'
	 SETB FL0
	KBs:

  POP PSW
  POP ACC

RETI

Start:	
	LCALL init_lcd

	MOV R0, #0
	MOV TH0, #156
	MOV TMOD, #00000010b
	MOV IEN0, #10000010b

	SETB TR0
	
Loop:

	JNB FL0, NOWRITE
	 MOV A, #02h
	 LCALL WRITE_C 

	 LCALL WRITE_KBB
	 CLR FL0
	NOWRITE:


JMP Loop		;nieskoczony cig skokw

WRITE_KBB:
	MOV A, R0
	LCALL WRITE_D
RET

WRITE_C:
	PUSH ACC	;wyslij acc na stos
busy_c:	MOV DPTR,#LCD_RC;do DPTR wpisz adres RC
	MOVX A, @DPTR	;przepisz RC do A
	JB ACC.7,busy_c	;wykonuj busy dopoki LCD nie jest wolny
	MOV DPTR,#LCD_WC;do DPTR wpisz adres WC
	POP ACC
	MOVX @DPTR, A
RET

WRITE_D:
	PUSH ACC	;wyslij acc na stos
busy_d:	MOV DPTR,#LCD_RC;do DPTR wpisz adres RC
	MOVX A, @DPTR	;przepisz RC do A
	JB ACC.7,busy_d	;wykonuj busy dopoki LCD nie jest wolny
	MOV DPTR,#LCD_WD;do DPTR wpisz adres WD
	POP ACC
	MOVX @DPTR, A
RET
	
init_lcd:
	MOV a,#38H
	LCALL WRITE_C
	MOV a,#01H
	LCALL WRITE_C
	MOV a,#0EH
	LCALL WRITE_C
	MOV a,#06H
	LCALL WRITE_C
RET


kbb_tab: DB '123A456B789C*0#D'

END	   		;koniec programu