$NOMOD51
$INCLUDE(REG517.INC)

TAB1 EQU 30h		;Przypisuje nazw wartoci liczbowej
LICZNIK EQU 10	


LCD_WC EQU 0FF2Ch	;LCD Write Command
LCD_WD EQU 0FF2Dh	;LCD Write Data
LCD_RC EQU 0FF2Eh	;LCD Read Command
LCD_RD EQU 0FF2Fh	;LCD Read Data

RFLAG EQU 20h
  FL0 EQU RFLAG.0	
  FL1 EQU RFLAG.1	
  FL2 EQU RFLAG.2

ORG 0000
LJMP START

ORG 000bh

  PUSH ACC
  PUSH PSW
	MOV TL0, #60
	MOV TH0, #176
	INC R1

	CJNE R1,#5,STEP
	  SETB FL0
	  INC R0
	  MOV R1, #0	
	STEP:

	CJNE R0,#10,STEP_SEC
	  INC R2
	  MOV R0, #0	
	STEP_SEC:

	CJNE R2, #60,STEP_MIN
	  INC R3
	  MOV R2, #0	
	STEP_MIN:

  POP PSW
  POP ACC

RETI

Start:	
	LCALL init_lcd

	MOV R0, #0
	MOV R1, #0
	MOV R2, #0
	MOV R3, #0
	MOV TL0, #60
	MOV TH0, #176
	MOV TMOD, #00000001b
	MOV IEN0, #10000010b
	
Loop:

	JB P3.2, NOSTART
		LCALL COUNTER_START
	NOSTART:

	JB P3.3, NOSTOP
		LCALL COUNTER_STOP
	NOSTOP:

	JB P3.4, NORESET
		LCALL COUNTER_RESET
	NORESET:

	JNB FL0, NOWRITE
	 MOV A, #02h
	 LCALL WRITE_C
	
	 MOV A, R3
	 LCALL WRITE_DEC

	 MOV A, #'.'
	 LCALL WRITE_D

	 MOV A, R2
	 LCALL WRITE_DEC2

	 MOV A, #'.'
	 LCALL WRITE_D

	 MOV A, R0
	 LCALL WRITE_DEC1

	 CLR FL0
	NOWRITE:


JMP Loop		;nieskoczony cig skokw

COUNTER_START:
	SETB TR0
RET

COUNTER_STOP:
	CLR TR0
RET

COUNTER_RESET:
	MOV R0, #0
	MOV R1, #0
	MOV R2, #0
	MOV R3, #0
	MOV TL0, #60
	MOV TH0, #176
	SETB FL0
RET



WRITE_DEC:

	MOV B, #100
	DIV AB
	MOV DPTR, #hex_tab
	MOVC A,@A+DPTR
	LCALL WRITE_D
	
	MOV A, B
	MOV B, #10
	DIV AB
	MOV DPTR, #hex_tab
	MOVC A,@A+DPTR
	LCALL WRITE_D

	MOV A, B
	MOV DPTR, #hex_tab
	MOVC A,@A+DPTR
	LCALL WRITE_D

RET

WRITE_DEC2:

	MOV B, #100
	DIV AB
	MOV A, B
	MOV B, #10
	DIV AB
	MOV DPTR, #hex_tab
	MOVC A,@A+DPTR
	LCALL WRITE_D

	MOV A, B
	MOV DPTR, #hex_tab
	MOVC A,@A+DPTR
	LCALL WRITE_D

RET

WRITE_DEC1:

	MOV B, #10
	DIV AB
	MOV A, B
	MOV DPTR, #hex_tab
	MOVC A,@A+DPTR
	LCALL WRITE_D

RET

WRITE_C:
	PUSH ACC	;wyslij acc na stos
busy_c:	MOV DPTR,#LCD_RC;do DPTR wpisz adres RC
	MOVX A, @DPTR	;przepisz RC do A
	JB ACC.7,busy_c	;wykonuj busy dopoki LCD nie jest wolny
	MOV DPTR,#LCD_WC;do DPTR wpisz adres WC
	POP ACC
	MOVX @DPTR, A
RET

WRITE_D:
	PUSH ACC	;wyslij acc na stos
busy_d:	MOV DPTR,#LCD_RC;do DPTR wpisz adres RC
	MOVX A, @DPTR	;przepisz RC do A
	JB ACC.7,busy_d	;wykonuj busy dopoki LCD nie jest wolny
	MOV DPTR,#LCD_WD;do DPTR wpisz adres WD
	POP ACC
	MOVX @DPTR, A
RET
	
init_lcd:
	MOV a,#38H
	LCALL WRITE_C
	MOV a,#01H
	LCALL WRITE_C
	MOV a,#0EH
	LCALL WRITE_C
	MOV a,#06H
	LCALL WRITE_C
RET


hex_tab: DB '0123456789ABCDEF'

END	   		;koniec programu