;-----------------------------------------------------------------------------
;	Copyright (C) 2000 CYGNAL INTEGRATED PRODUCTS, INC.
; 	All rights reserved.
;
;
; 	FILE NAME  	: C8051F000.INC 
; 	TARGET MCU	: C8051F0xx (C8051 System Controller)
; 	DESCRIPTION	: Register/bit definitions for the C8051F000 product family.  
;
; 	REVISION 1.8 	
;
;-----------------------------------------------------------------------------
;REGISTER DEFINITIONS
;
P0       DATA  080H   ; PORT 0
SP       DATA  081H   ; STACK POINTER
DPL      DATA  082H   ; DATA POINTER - LOW BYTE
DPH      DATA  083H   ; DATA POINTER - HIGH BYTE
PCON     DATA  087H   ; POWER CONTROL
TCON     DATA  088H   ; TIMER CONTROL
TMOD     DATA  089H   ; TIMER MODE
TL0      DATA  08AH   ; TIMER 0 - LOW BYTE
TL1      DATA  08BH   ; TIMER 1 - LOW BYTE
TH0      DATA  08CH   ; TIMER 0 - HIGH BYTE
TH1      DATA  08DH   ; TIMER 1 - HIGH BYTE
CKCON    DATA  08EH   ; CLOCK CONTROL
PSCTL    DATA  08FH   ; PROGRAM STORE R/W CONTROL
P1       DATA  090H   ; PORT 1
TMR3CN   DATA  091H   ; TIMER 3 CONTROL
TMR3RLL  DATA  092H   ; TIMER 3 RELOAD REGISTER - LOW BYTE
TMR3RLH  DATA  093H   ; TIMER 3 RELOAD REGISTER - HIGH BYTE
TMR3L    DATA  094H   ; TIMER 3 - LOW BYTE
TMR3H    DATA  095H   ; TIMER 3 - HIGH BYTE
DSRFLG   DATA  097H   ; DSR FLAG REGISTER
SCON     DATA  098H   ; SERIAL PORT CONTROL
SBUF     DATA  099H   ; SERIAL PORT BUFFER
SPI0CFG  DATA  09AH   ; SERIAL PERIPHERAL INTERFACE 0 CONFIGURATION
SPI0DAT  DATA  09BH   ; SERIAL PERIPHERAL INTERFACE 0 DATA
SPI0CKR  DATA  09DH   ; SERIAL PERIPHERAL INTERFACE 0 CLOCK RATE CONTROL
CPT0CN   DATA  09EH   ; COMPARATOR 0 CONTROL
CPT1CN   DATA  09FH   ; COMPARATOR 1 CONTROL 
P2       DATA  0A0H   ; PORT 2
PRT0CF   DATA  0A4H   ; PORT 0 CONFIGURATION
PRT1CF   DATA  0A5H   ; PORT 1 CONFIGURATION
PRT2CF   DATA  0A6H   ; PORT 2 CONFIGURATION
PRT3CF   DATA  0A7H   ; PORT 3 CONFIGURATION 
IE       DATA  0A8H   ; INTERRUPT ENABLE
PRT1IF   DATA  0ADH   ; PORT 1 EXTERNAL INTERRUPT FLAGS
EMI0CN   DATA  0AFH   ; EXTERNAL MEMORY INTERFACE CONTROL
P3       DATA  0B0H   ; PORT 3
OSCXCN   DATA  0B1H   ; EXTERNAL OSCILLATOR CONTROL
OSCICN   DATA  0B2H   ; INTERNAL OSCILLATOR CONTROL
DSRL     DATA  0B3H   ; DSR PORT - LOW BYTE
DSRH     DATA  0B4H   ; DSR PORT - HIGH BYTE
FLSCL    DATA  0B6H   ; FLASH MEMORY TIMING PRESCALER
FLACL    DATA  0B7H   ; FLASH ACESS LIMIT 
IP       DATA  0B8H   ; INTERRUPT PRIORITY
AMX0CF   DATA  0BAH   ; ADC 0 MUX CONFIGURATION
AMX0SL   DATA  0BBH   ; ADC 0 MUX CHANNEL SELECTION
ADC0CF   DATA  0BCH   ; ADC 0 CONFIGURATION
ADC0L    DATA  0BEH   ; ADC 0 DATA - LOW BYTE
ADC0H    DATA  0BFH   ; ADC 0 DATA - HIGH BYTE 
SMB0CN   DATA  0C0H   ; SMBUS 0 CONTROL
SMB0STA  DATA  0C1H   ; SMBUS 0 STATUS
SMB0DAT  DATA  0C2H   ; SMBUS 0 DATA 
SMB0ADR  DATA  0C3H   ; SMBUS 0 SLAVE ADDRESS
ADC0GTL  DATA  0C4H   ; ADC 0 GREATER-THAN REGISTER - LOW BYTE
ADC0GTH  DATA  0C5H   ; ADC 0 GREATER-THAN REGISTER - HIGH BYTE
ADC0LTL  DATA  0C6H   ; ADC 0 LESS-THAN REGISTER - LOW BYTE
ADC0LTH  DATA  0C7H   ; ADC 0 LESS-THAN REGISTER - HIGH BYTE
T2CON    DATA  0C8H   ; TIMER 2 CONTROL
RCAP2L   DATA  0CAH   ; TIMER 2 CAPTURE REGISTER - LOW BYTE
RCAP2H   DATA  0CBH   ; TIMER 2 CAPTURE REGISTER - HIGH BYTE
TL2      DATA  0CCH   ; TIMER 2 - LOW BYTE
TH2      DATA  0CDH   ; TIMER 2 - HIGH BYTE
DSROP    DATA  0CEH   ; DSR OPERAND
SMB0CR   DATA  0CFH   ; SMBUS 0 CLOCK RATE
PSW      DATA  0D0H   ; PROGRAM STATUS WORD
REF0CN   DATA  0D1H   ; VOLTAGE REFERENCE 0 CONTROL
DAC0L    DATA  0D2H   ; DAC 0 REGISTER - LOW BYTE
DAC0H    DATA  0D3H   ; DAC 0 REGISTER - HIGH BYTE
DAC0CN   DATA  0D4H   ; DAC 0 CONTROL
DAC1L    DATA  0D5H   ; DAC 1 REGISTER - LOW BYTE
DAC1H    DATA  0D6H   ; DAC 1 REGISTER - HIGH BYTE
DAC1CN   DATA  0D7H   ; DAC 1 CONTROL
PCA0CN   DATA  0D8H   ; PCA 0 COUNTER CONTROL
PCA0MD   DATA  0D9H   ; PCA 0 COUNTER MODE
PCA0CPM0 DATA  0DAH   ; CONTROL REGISTER FOR PCA 0 MODULE 0
PCA0CPM1 DATA  0DBH   ; CONTROL REGISTER FOR PCA 0 MODULE 1
PCA0CPM2 DATA  0DCH   ; CONTROL REGISTER FOR PCA 0 MODULE 2
PCA0CPM3 DATA  0DDH   ; CONTROL REGISTER FOR PCA 0 MODULE 3
PCA0CPM4 DATA  0DEH   ; CONTROL REGISTER FOR PCA 0 MODULE 4
ACC      DATA  0E0H   ; ACCUMULATOR
XBR0     DATA  0E1H   ; DIGITAL CROSSBAR CONFIGURATION REGISTER 0
XBR1     DATA  0E2H   ; DIGITAL CROSSBAR CONFIGURATION REGISTER 1
XBR2     DATA  0E3H   ; DIGITAL CROSSBAR CONFIGURATION REGISTER 2
EIE1     DATA  0E6H   ; EXTERNAL INTERRUPT ENABLE 1
EIE2     DATA  0E7H   ; EXTERNAL INTERRUPT ENABLE 2
ADC0CN   DATA  0E8H   ; ADC 0 CONTROL
PCA0L    DATA  0E9H   ; PCA 0 TIMER - LOW BYTE
PCA0CPL0 DATA  0EAH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 0 - LOW BYTE
PCA0CPL1 DATA  0EBH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 1 - LOW BYTE
PCA0CPL2 DATA  0ECH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 2 - LOW BYTE
PCA0CPL3 DATA  0EDH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 3 - LOW BYTE
PCA0CPL4 DATA  0EEH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 4 - LOW BYTE
RSTSRC   DATA  0EFH   ; RESET SOURCE 
B        DATA  0F0H   ; B REGISTER
EIP1     DATA  0F6H   ; EXTERNAL INTERRUPT PRIORITY REGISTER 1
EIP2     DATA  0F7H   ; EXTERNAL INTERRUPT PRIORITY REGISTER 2
SPI0CN   DATA  0F8H   ; SERIAL PERIPHERAL INTERFACE 0 CONTROL 
PCA0H    DATA  0F9H   ; PCA 0 TIMER - HIGH BYTE
PCA0CPH0 DATA  0FAH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 0 - HIGH BYTE
PCA0CPH1 DATA  0FBH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 1 - HIGH BYTE
PCA0CPH2 DATA  0FCH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 2 - HIGH BYTE
PCA0CPH3 DATA  0FDH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 3 - HIGH BYTE
PCA0CPH4 DATA  0FEH   ; CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 4 - HIGH BYTE
WDTCN    DATA  0FFH   ; WATCHDOG TIMER CONTROL 
;
;------------------------------------------------------------------------------
;BIT DEFINITIONS
;
; TCON 88H
IT0      BIT   TCON.0 ; EXT. INTERRUPT 0 TYPE
IE0      BIT   TCON.1 ; EXT. INTERRUPT 0 EDGE FLAG
IT1      BIT   TCON.2 ; EXT. INTERRUPT 1 TYPE
IE1      BIT   TCON.3 ; EXT. INTERRUPT 1 EDGE FLAG
TR0      BIT   TCON.4 ; TIMER 0 ON/OFF CONTROL
TF0      BIT   TCON.5 ; TIMER 0 OVERFLOW FLAG
TR1      BIT   TCON.6 ; TIMER 1 ON/OFF CONTROL
TF1      BIT   TCON.7 ; TIMER 1 OVERFLOW FLAG
;
; SCON 98H
RI       BIT   SCON.0 ; RECEIVE INTERRUPT FLAG
TI       BIT   SCON.1 ; TRANSMIT INTERRUPT FLAG
RB8      BIT   SCON.2 ; RECEIVE BIT 8
TB8      BIT   SCON.3 ; TRANSMIT BIT 8
REN      BIT   SCON.4 ; RECEIVE ENABLE
SM2      BIT   SCON.5 ; MULTIPROCESSOR COMMUNICATION ENABLE
SM1      BIT   SCON.6 ; SERIAL MODE CONTROL BIT 1
SM0      BIT   SCON.7 ; SERIAL MODE CONTROL BIT 0
; 
; IE A8H
EX0      BIT   IE.0   ; EXTERNAL INTERRUPT 0 ENABLE
ET0      BIT   IE.1   ; TIMER 0 INTERRUPT ENABLE
EX1      BIT   IE.2   ; EXTERNAL INTERRUPT 1 ENABLE
ET1      BIT   IE.3   ; TIMER 1 INTERRUPT ENABLE
ES       BIT   IE.4   ; SERIAL PORT INTERRUPT ENABLE
ET2      BIT   IE.5   ; TIMER 2 INTERRUPT ENABLE
EA       BIT   IE.7   ; GLOBAL INTERRUPT ENABLE
;
; IP B8H
PX0      BIT   IP.0   ; EXTERNAL INTERRUPT 0 PRIORITY
PT0      BIT   IP.1   ; TIMER 0 PRIORITY
PX1      BIT   IP.2   ; EXTERNAL INTERRUPT 1 PRIORITY
PT1      BIT   IP.3   ; TIMER 1 PRIORITY
PS       BIT   IP.4   ; SERIAL PORT PRIORITY
PT2      BIT   IP.5   ; TIMER 2 PRIORITY
;
; SMB0CN C0H
SMBTOE   BIT   SMB0CN.0 ; SMBUS 0 TIMEOUT ENABLE
SMBFTE   BIT   SMB0CN.1 ; SMBUS 0 FREE TIMER ENABLE
AA       BIT   SMB0CN.2 ; SMBUS 0 ASSERT/ACKNOWLEDGE FLAG
SI       BIT   SMB0CN.3 ; SMBUS 0 INTERRUPT PENDING FLAG
STO      BIT   SMB0CN.4 ; SMBUS 0 STOP FLAG
STA      BIT   SMB0CN.5 ; SMBUS 0 START FLAG
ENSMB    BIT   SMB0CN.6 ; SMBUS 0 ENABLE 
;
; T2CON C8H
CPRL2    BIT   T2CON.0 ; CAPTURE OR RELOAD SELECT
CT2      BIT   T2CON.1 ; TIMER OR COUNTER SELECT
TR2      BIT   T2CON.2 ; TIMER 2 ON/OFF CONTROL
EXEN2    BIT   T2CON.3 ; TIMER 2 EXTERNAL ENABLE FLAG
TCLK     BIT   T2CON.4 ; TRANSMIT CLOCK FLAG
RCLK     BIT   T2CON.5 ; RECEIVE CLOCK FLAG
EXF2     BIT   T2CON.6 ; EXTERNAL FLAG
TF2      BIT   T2CON.7 ; TIMER 2 OVERFLOW FLAG
;
; PSW D0H
P        BIT   PSW.0  ; ACCUMULATOR PARITY FLAG
F1       BIT   PSW.1  ; USER FLAG 1
OV       BIT   PSW.2  ; OVERFLOW FLAG
RS0      BIT   PSW.3  ; REGISTER BANK SELECT 0
RS1      BIT   PSW.4  ; REGISTER BANK SELECT 1
F0       BIT   PSW.5  ; USER FLAG 0
AC       BIT   PSW.6  ; AUXILIARY CARRY FLAG
CY       BIT   PSW.7  ; CARRY FLAG
;
; PCA0CN D8H
CCF0     BIT   PCA0CN.0 ; PCA 0 MODULE 0 INTERRUPT FLAG
CCF1     BIT   PCA0CN.1 ; PCA 0 MODULE 1 INTERRUPT FLAG
CCF2     BIT   PCA0CN.2 ; PCA 0 MODULE 2 INTERRUPT FLAG
CCF3     BIT   PCA0CN.3 ; PCA 0 MODULE 3 INTERRUPT FLAG
CCF4     BIT   PCA0CN.4 ; PCA 0 MODULE 4 INTERRUPT FLAG
CR       BIT   PCA0CN.6 ; PCA 0 COUNTER RUN CONTROL BIT
CF       BIT   PCA0CN.7 ; PCA 0 COUNTER OVERFLOW FLAG
;
; ADC0CN E8H
ADLJST   BIT   ADC0CN.0 ; ADC 0 RIGHT JUSTIFY DATA BIT
ADWINT   BIT   ADC0CN.1 ; ADC 0 WINDOW COMPARE INTERRUPT FLAG
ADSTM0   BIT   ADC0CN.2 ; ADC 0 START OF CONVERSION MODE BIT 0
ADSTM1   BIT   ADC0CN.3 ; ADC 0 START OF CONVERSION MODE BIT 1
ADBUSY   BIT   ADC0CN.4 ; ADC 0 BUSY FLAG
ADCINT   BIT   ADC0CN.5 ; ADC 0 CONVERISION COMPLETE INTERRUPT FLAG 
ADCTM    BIT   ADC0CN.6 ; ADC 0 TRACK MODE
ADCEN    BIT   ADC0CN.7 ; ADC 0 ENABLE
;
; SPI0CN F8H
SPIEN    BIT   SPI0CN.0 ; SPI 0 SPI ENABLE
MSTEN    BIT   SPI0CN.1 ; SPI 0 MASTER ENABLE
SLVSEL   BIT   SPI0CN.2 ; SPI 0 SLAVE SELECT
TXBSY    BIT   SPI0CN.3 ; SPI 0 TX BUSY FLAG
RXOVRN   BIT   SPI0CN.4 ; SPI 0 RX OVERRUN FLAG
MODF     BIT   SPI0CN.5 ; SPI 0 MODE FAULT FLAG
WCOL     BIT   SPI0CN.6 ; SPI 0 WRITE COLLISION FLAG
SPIF     BIT   SPI0CN.7 ; SPI 0 INTERRUPT FLAG
