%  MINIMALIZACJA FUNKCJI JEDNEJ ZMIENNEJ
%
%	METODA PRZEGLADU ZUPELNEGO
%
%	Skadnia:	[Mat minf iter]=przeglad(a,b,l,fun,par)
%
%	Wielkosci wyjsciowe:
%		Mat=|	1	a1	f(a1)	b1	f(b1)	|
%		    |	.	.	.	.	.	|
%		    |	n	an	f(an)	bn	f(bn)	|
%		minf=[a*,b*]
%		iter - ilosc wykonanych iteracji
%		ilfun - ilosc wyliczen funkcji celu
%
%	Wielkosci wejsciowe:
%		[a,b] - przedzial w ktorym ma byc poszukiwane minimum
%		l - warunek stopu (dokladnosc obliczen)
%		fun - nazwa funkcji ktora badamy, np. 'f1'
%		par - parametry funkcji celu
%
%

function [Mat,minf,iter, F_iter]=przeglad(a,b,l,fun,par)
	if (abs(b-a)/l>99999),
		blad('Przekroczono dopuszczaln ilo oblicze !','Zmniejsz dokadno lub przedzia',1);
		err=1;
		
'jacek'
		save error err
		return;
	end
	x=[a:l:b];
	y=eval([fun '(par,x)']);		
	x_o=x(find(y==min(y)));	
	minf=[x_o(1) min(y)];
	iter=size(x,2);
	F_iter=iter;
	Mat=[1:size(x,2);x;y]';
